define([
    'jquery',
    'backbone',
    'Layout',
    'modules/new-appointment-request/resources/direct/preferred-date/time-slots-by-date-collection',
    'modules/new-appointment-request/views/direct/preferred-date/preferred-date-available',
], function($, Backbone, Layout, TimeSlotsByDateCollection, PreferredDateAvailableView) {
    'use strict';

    describe('Preferred Date Available View', function() {
        var view;
        var $view;
        var model = new Backbone.Model({desiredDate: '06/12/2016'});
        var timeSlotsByDateCollection = new TimeSlotsByDateCollection([
            {date: '06/11/2016'},
            {date: '06/12/2016'},
            {date: '06/14/2016'},
        ]);
        var layout = new Layout();

        layout.render();

        beforeEach(function() {
            spyOn(PreferredDateAvailableView.prototype, 'showDateCollapsibleView');
            spyOn(PreferredDateAvailableView.prototype, 'focusOnLegend').and.callThrough();
            spyOn($.fn, 'trigger').and.callThrough();

            view = new PreferredDateAvailableView({
                model: model,
                timeSlotsByDateCollection: timeSlotsByDateCollection,
            });

            layout.showChildView('content', view);
            $view = view.$el;
        });

        afterEach(function() {
            layout.getRegion('content').empty();
        });

        describe('on show', function() {
            it('has a legend and description text', function () {
                expect($view.find('legend').text()).toEqual('*\xa0Select Date/Time:');
                expect($view.find('#available-dates-times-description').text()).toEqual('The following times are available on your preferred date:');
            });

            it('has a container region', function () {
                expect($view.has(view.regions.containerRegion).length).toEqual(1);
            });

            it('calls showDateCollapsibleView and triggers creation of jQuery Mobile widgets', function () {
                expect(view.showDateCollapsibleView).toHaveBeenCalled();
                expect($.fn.trigger).toHaveBeenCalledWith('create');
            });

            xit('calls function to focusOnLegend()', function() {
                // unable to test focus in headless browser
                expect(view.focusOnLegend).toHaveBeenCalled();
                expect($.find('legend span[tabindex]').length).toEqual(1);
            });
        });
    });
}
);
